//
//	Class definition for Change Player Dialog class
//

#ifndef THE_CHANGE_PLAYER_DIALOG_H
#define THE_CHANGE_PLAYER_DIALOG_H

#include "ldwTiledDialog.h"

class theGameState;
class ldwButton;
class ldwTextControl;
class ldwFont;
class ldwTiledBackground;

class theChangePlayerDlg : public ldwTiledDialog
{
public:

	theChangePlayerDlg(int dlgCanvas);
	~theChangePlayerDlg();

	int  GetResult();

	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMessage(int messageId,long data);

	bool PlayerHasChanged();

protected:

	enum {eOkButtonId = 1,
	      eCancelButtonId,

	      eNameSlot1Id = 100,
	      eNameSlot2Id,
	      eNameSlot3Id,
	      eNameSlot4Id,
	      eNameSlot5Id,

		  eNameSlot1UnderLineId = 200,
		  eNameSlot2UnderLineId,
		  eNameSlot3UnderLineId,
		  eNameSlot4UnderLineId,
		  eNameSlot5UnderLineId,

		  eDeleteSlot1Id = 300,
		  eDeleteSlot2Id,
		  eDeleteSlot3Id,
		  eDeleteSlot4Id,
		  eDeleteSlot5Id,

		  eNoSlot = -1,

		  eSlot1Index = 0,
		  eSlot2Index,
		  eSlot3Index,
		  eSlot4Index,
		  eSlot5Index,

		  eSlotCount
	      };

	void UpdateFocus();
	void ChangeFocus(bool hasFocus);

	void DrawNoFadeScene();

	theGameState *mGs;

	ldwButton *mDeleteButtons[eSlotCount];

	int  mCurrentFocusSlot;

	int  mEditSlot;

	bool mIgnoreEndEdit;

	int  mResult;

	int mDlgCanvas;
	int mAdjustY;

	ldwUINT32 mStartTime;
};

#endif
